@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            إدارة الملفات
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">




                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">

            @if (session('success'))
                <div class="col-12">
                    <div class="alert alert-success" role="alert">
                        <h4 class="alert-title">Success</h4>
                        <div class="text-muted">{{ session('success') }}</div>
                    </div>
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    <h4 class="alert-title">Error&hellip;</h4>
                    <div class="text-muted">{{ session('error') }}</div>
                </div>
            @endif


            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">
                        <h1> رفع فيديوهات الكورس </h1>
                        <p> {{ str_replace('Virtual Court/', '', $folder) }} </p>

                        <form id="uploadForm" action="{{ route('admin.files.upload') }}" method="POST"
                            enctype="multipart/form-data" class="form-row align-items-center">
                            @csrf
                            <div class="row">
                                <!-- File Upload Field -->
                                <div class="col-lg-5 col-md-5 col-sm-12 mb-2">
                                    <input type="file" class="form-control" name="file"
                                        placeholder="Upload from device">
                                </div>

                                <!-- Direct Link Input Field -->
                                <div class="col-lg-5 col-md-5 col-sm-12 mb-2">
                                    <input type="url" class="form-control" name="file_url" placeholder="Paste file URL">
                                </div>

                                <!-- Hidden Directory Field -->
                                <input type="hidden" class="form-control" name="dir" value="{{ $folder }}">

                                <!-- Submit Button -->
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                    <button type="submit" class="btn btn-primary btn-block" id="uploadButton">رفع
                                        الفيديو</button>
                                </div>
                            </div>
                        </form>



                        <br />

                        <h2>الفيديوهات الحالية</h2>


                        <div class="col-12">
                            <div class="card">
                                <div class="table-responsive">
                                    <table class="table table-vcenter card-table">
                                        <thead>
                                            <tr>
                                                <th>اسم الفيديو</th>
                                                <th>الرابط</th>
                                                <th>حذف</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($files as $file)
                                                <tr>
                                                    <td> {{ str_replace('/', '', str_replace($folder, '', $file)) }} </td>
                                                    <td class="text-muted text-blue">
                                                        {{ $file }}
                                                    </td>

                                                    <td>

                                                        <form
                                                            action="{{ route('admin.files.delete', rawurlencode($file)) }}"
                                                            method="POST" style="display:inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button class="btn btn-red" type="submit">Delete</button>
                                                        </form>



                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#uploadForm').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                var formData = new FormData(this);
                var submitButton = $('#uploadButton');

                // Validate inputs
                var fileInput = $('input[name="file"]').val();
                var urlInput = $('input[name="file_url"]').val();

                if (!fileInput && !urlInput) {
                    alert('Please select a file or enter a file URL.');
                    return;
                }

                // AJAX Request
                $.ajax({
                    xhr: function() {
                        var xhr = new window.XMLHttpRequest();
                        xhr.upload.addEventListener('progress', function(e) {
                            if (e.lengthComputable) {
                                var percentComplete = Math.round((e.loaded / e.total) *
                                    100);
                                var progressText = percentComplete === 100 ?
                                    'Completing upload...' :
                                    'Uploading: ' + percentComplete + '%';
                                submitButton.text(progressText);
                            }
                        }, false);
                        return xhr;
                    },
                    url: "{{ route('admin.files.upload') }}",
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        submitButton.prop('disabled', true);
                    },
                    success: function(response) {
                        window.location.reload(); // Refresh on success
                    },
                    error: function(response) {
                        // Extract error message if available
                        let errorMessage = 'File upload failed. Please try again.';

                        if (response.responseJSON && response.responseJSON.message) {
                            errorMessage = response.responseJSON.message;
                        } else if (response.statusText) {
                            errorMessage = `Error ${response.status}: ${response.statusText}`;
                        }

                        alert(errorMessage); // Show detailed error message
                        submitButton.prop('disabled', false);
                        submitButton.text('رفع الفيديو');
                    }
                });
            });
        });
    </script>
@endpush
