@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            {{ __('admin.workshops') }}
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                {{ __('admin.add_new_workshop') }}
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th>{{ __('admin.id') }}</th>
                                        <th>{{ __('admin.name') }}</th>
                                        <th>{{ __('admin.category') }}</th>
                                        <th>{{ __('admin.price') }}</th>

                                        <th>{{ __('admin.is_free') }}</th>
                                        <th> التفعيل </th>
                                        <th>{{ __('admin.created_at') }}</th>
                                        <th>{{ __('admin.updated_at') }}</th>
                                        <th>{{ __('admin.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($workshops as $workshop)
                                        <tr>
                                            <td>{{ $workshop->id }}</td>
                                            <td>{{ $workshop->name }}</td>
                                            <td>{{ $workshop->category->name }}</td>
                                            <td>{{ $workshop->price }}</td>

                                            <td>{{ $workshop->is_free ? __('admin.yes') : __('admin.no') }}</td>

                                            <td>
                                                @if ($workshop->is_active == '0')
                                                    <div style="cursor: pointer;width:20px;height:20px;border-radius:10px;background:red;"
                                                        onclick="window.location.href='{{ route('admin.workshops.toggle', ['id' => $workshop->id, 'state' => '1']) }}'">
                                                    </div>
                                                @else
                                                    <div style="width:20px;height:20px;border-radius:10px;background:green;cursor: pointer;"
                                                        onclick="window.location.href='{{ route('admin.workshops.toggle', ['id' => $workshop->id, 'state' => '0']) }}'">
                                                    </div>
                                                @endif

                                            </td>
                                            <td>{{ $workshop->created_at->diffForHumans() }}</td>
                                            <td>{{ $workshop->updated_at->diffForHumans() }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    <button class="btn dropdown-toggle align-text-top"
                                                        data-bs-toggle="dropdown" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a href="{{ route('admin.workshops.students', $workshop->id) }}"
                                                            class="dropdown-item"> {{ __('admin.students') }} </a>
                                                        <a href="{{ route('admin.workshops.joins', $workshop->id) }}"
                                                            class="dropdown-item"> طلبات الانضمام </a>
                                                        <a href="{{ route('admin.workshops.show', $workshop->id) }}"
                                                            class="dropdown-item"> {{ __('admin.coupons') }} </a>
                                                        <button type="button" class="dropdown-item"
                                                            onclick="edit('{{ $workshop->id }}')">{{ __('admin.edit') }}</button>
                                                        <a href="{{ route('admin.files.in.folders', rawurlencode('Virtual Court/workshop/w_' . $workshop->id)) }}"
                                                            target="_blank" class="dropdown-item"> رفع الملفات </a>
                                                        <button type="button" class="dropdown-item"
                                                            onclick="deleteRecord('{{ route('admin.workshops.destroy', ['workshop' => $workshop->id]) }}')">{{ __('admin.delete') }}</button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        {{--                        <div class="row"> --}}
                        {{--                            <div class="pagination"> --}}
                        {{--                                {!! $lots->links('pagination::bootstrap-4') !!} --}}
                        {{--                            </div> --}}
                        {{--                        </div> --}}
                    </div>

                </div>
            </div>
        </div>

        {{--        modals --}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('admin.create_new_workshop') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('admin.workshops.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body scrollable-modal">
                            <div class="row mt-3">
                                <div class="col-12">
                                    <button type="button" onclick="setDir('ltr')" class="btn btn-light">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="4" y1="12" x2="14" y2="12" />
                                            <line x1="4" y1="18" x2="18" y2="18" />
                                        </svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="10" y1="12" x2="20" y2="12" />
                                            <line x1="6" y1="18" x2="20" y2="18" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.name') }}</label>
                                        <input class="form-control @error('name') is-invalid @enderror direc"
                                            type="text" name="name" placeholder="{{ __('admin.enter_name') }}">
                                        @error('name')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.description') }}</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror direc" name="description"
                                            placeholder="{{ __('admin.description') }}"></textarea>
                                        @error('description')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.image') }}</label>
                                        <input class="form-control @error('image') is-invalid @enderror" type="file"
                                            name="image">
                                        @error('image')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.pdf') }}</label>
                                        <input class="form-control @error('pdf') is-invalid @enderror" type="file"
                                            name="pdf">
                                        @error('pdf')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.price') }}</label>
                                        <input class="form-control @error('price') is-invalid @enderror" type="text"
                                            name="price" placeholder="{{ __('admin.price') }}">
                                        @error('price')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.is_free') }}</label>
                                        <select class="form-control @error('is_free') is-invalid @enderror"
                                            name="is_free">
                                            <option value="0">{{ __('admin.no') }}</option>
                                            <option value="1">{{ __('admin.yes') }}</option>
                                        </select>
                                        @error('is_free')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>التصنيف</label>
                                        <select class="form-select @error('category_id') is-invalid @enderror"
                                            name="category_id">
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>



                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto"
                                data-bs-dismiss="modal">{{ __('admin.close') }}</button>
                            <button type="submit" class="btn btn-primary"> {{ __('admin.create_workshop') }} </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal --}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
    @endsection

    @push('scripts')
        <script>
            const dropdowns = document.querySelectorAll('.dropdown-toggle')
            const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                popperConfig(defaultBsPopperConfig) {
                    return {
                        ...defaultBsPopperConfig,
                        strategy: 'fixed'
                    };
                }
            }));

            let loader = `@include('components.loader')`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/workshops/${id}/edit`);
            }


            function setDir(dir) {
                // Use querySelectorAll for more modern and efficient element selection
                const elements = document.querySelectorAll('.direc');

                if (elements.length === 0) {
                    console.warn("No elements found with class 'direc'.");
                    return; // Exit the function if no elements are found
                }

                if (dir.toLowerCase() === 'rtl') {
                    elements.forEach(element => element.setAttribute('dir', 'rtl'));
                } else if (dir.toLowerCase() === 'ltr') {
                    elements.forEach(element => element.setAttribute('dir', 'ltr'));
                } else {
                    console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                }
            }
        </script>
        <script>
            function deleteRecord(action) {
                console.log(action);
                $("#remove-form").attr('action', action);
                $("#modal-danger").modal('show');
            }
        </script>
    @endpush
