<div class="modal-header">
    <h5 class="modal-title">{{ __('admin.edit_workshop') }}</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('admin.close') }}"></button>
</div>
<form action="{{ route('admin.workshops.update', ['workshop' => $workshop->id]) }}" method="post"
    enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="modal-body scrollable-modal">
        <div class="row mt-3">
            <div class="col-12">
                <button type="button" onclick="setDir('ltr')" class="btn btn-light">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="4" y1="12" x2="14" y2="12" />
                        <line x1="4" y1="18" x2="18" y2="18" />
                    </svg>
                </button>
                <button type="button" onclick="setDir('rtl')" class="btn btn-light">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="10" y1="12" x2="20" y2="12" />
                        <line x1="6" y1="18" x2="20" y2="18" />
                    </svg>
                </button>
            </div>

            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
                    <div class="form-group">
                        <label>{{ __('admin.name') }}</label>
                        <input class="form-control @error('name') is-invalid @enderror direc" type="text"
                            name="name" placeholder="{{ __('admin.enter_name') }}" value="{{ $workshop->name }}">
                        @error('name')
                            <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
                    <div class="form-group">
                        <label>{{ __('admin.category') }}</label>
                        <select class="form-select direc" name="category_id">

                            @foreach ($categories as $category)
                                <option @if ($category->id == $workshop->category_id) selected @endif value="{{ $category->id }}">
                                    {{ $category->name }}</option>
                            @endforeach
                        </select>
                        @error('category_id')
                            <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.description') }}</label>
                    <textarea class="form-control @error('description') is-invalid @enderror direc" name="description"
                        placeholder="{{ __('admin.enter_description') }}">{{ $workshop->description }}</textarea>
                    @error('description')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.image') }}</label>
                    <input class="form-control @error('image') is-invalid @enderror" type="file" name="image">
                    @error('image')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                    <img src="{{ asset($workshop->image) }}" alt="{{ __('admin.image') }}" class="img-thumbnail mt-2"
                        width="100">
                </div>
            </div>

            <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.pdf') }}</label>
                    <input class="form-control @error('pdf') is-invalid @enderror" type="file" name="pdf">
                    @error('pdf')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.long_video') }}</label>
                    <input class="form-control @error('long_video') is-invalid @enderror" type="text"
                        name="long_video" placeholder="{{ __('admin.enter_youtube_link_long') }}"
                        value="{{ $workshop->long_video }}">
                    @error('long_video')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.short_video') }}</label>
                    <input class="form-control @error('short_video') is-invalid @enderror" type="text"
                        name="short_video" placeholder="{{ __('admin.enter_youtube_link_short') }}"
                        value="{{ $workshop->short_video }}">
                    @error('short_video')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.price') }}</label>
                    <input class="form-control @error('price') is-invalid @enderror" type="text" name="price"
                        placeholder="{{ __('admin.enter_price') }}" value="{{ $workshop->price }}">
                    @error('price')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>


            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.is_free') }}</label>
                    <select class="form-control @error('is_free') is-invalid @enderror" name="is_free">
                        <option value="0" {{ $workshop->is_free == 0 ? 'selected' : '' }}>{{ __('admin.no') }}
                        </option>
                        <option value="1" {{ $workshop->is_free == 1 ? 'selected' : '' }}>{{ __('admin.yes') }}
                        </option>
                    </select>
                    @error('is_free')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>



        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn me-auto" data-bs-dismiss="modal">{{ __('admin.close') }}</button>
        <button type="submit" class="btn btn-primary">{{ __('admin.save') }}</button>
    </div>
</form>
