@extends('layouts.tabler-vertical')
@section('title','Admin Users')
@push('styles')
    @livewireStyles
@endpush

@section('header-top')
    <style>
        .table-responsive .dropdown,
        .table-responsive .btn-group,
        .table-responsive .btn-group-vertical {
            position: static;
        }
    </style>
    @include('layouts.inc.top-large-bar')

    <div class="page-wrapper">

        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            @lang('admin.users')
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="btn-list">

                            <button type="button"  class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal" data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <i class='bx bxs-user' ></i> @lang('admin.create_new_user')
                            </button>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal" data-bs-target="#modal-report" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="12" y1="5" x2="12" y2="19" /><line x1="5" y1="12" x2="19" y2="12" /></svg>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
        @endsection
@section('content')
    <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('admin.create_new_user')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{route('admin.users.store')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row mt-3">
                            <div class="col-lg-6 col-md-6 col-sm-12 mt-3">
                                <div class="form-group">
                                    <label>@lang('admin.user_name')</label>
                                    <input class="form-control" type="text" name="name" placeholder="@lang('admin.user_name')">
                                    @error('name') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 mt-3">
                                <div class="form-group">
                                    <label>@lang('admin.phone')</label>
                                    <input class="form-control" type="text" name="phone" placeholder="@lang('admin.phone')">
                                    @error('phone') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 mt-3">
                                <div class="form-group">
                                    <label>@lang('admin.enter_email_address')</label>
                                    <input class="form-control" type="text" name="email" placeholder="@lang('admin.enter_email_address')">
                                    @error('email') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 mt-3">
                                <div class="form-group">
                                    <label>@lang('admin.type_password')</label>
                                    <input class="form-control" type="text" name="password" placeholder="@lang('admin.type_password')">
                                    @error('password') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6  col-sm-12 mt-3"  >
                                <div class="form-group">
                                    <label>@lang('admin.select_role')</label>
                                    <select class="form-select" type="text" name="role_id">
                                        @foreach($roles as $role)
                                            <option value="{{$role->id}}">{{$role->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('role_id') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                </div>
                            </div>

                            @include('components.intelegent_image_uploader',['cssclass'=>'col-6 col-sm-12 mt-3','image_input_name'=>'image','title'=>__('admin.user_image')])

                            <div class="col-lg-12 col-md-12 col-sm-12  mt-1 ">
                                <div class="form-group">
                                    <label>@lang('admin.type_his_bio')</label>
                                    <textarea class="form-control" type="text" name="bio" placeholder="@lang('admin.type_his_bio')"></textarea>
                                    @error('bio') <small  class="form-text  text-danger">{{ $message }}</small>  @enderror
                                </div>
                            </div>


                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn me-auto" data-bs-dismiss="modal">@lang('admin.close')</button>
                        <button type="submit" class="btn btn-primary">@lang('admin.create_user')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="wrapper ">


        <livewire:users-table/>

    </div>


            <div class="modal modal-blur fade"   id="modal-wallet" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">charge wallet for  <span id="wallet-name"> </span> </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{route('admin.process.user.wallet')}}" method="POST">
                            @csrf
                        <div class="modal-body">

                            <label class="form-label"> Enter the amount  </label>
                            <input class="form-control" placeholder="amount" name="amount" id="amount">
                            <input id="u_wallet_id" type="text" name="user_id" hidden>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal" >Close</button>
                            <button type="submit" class="btn btn-primary" data-bs-dismiss="modal"  >Save changes</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>
            
            

@endsection
@push('scripts')
    @livewireScripts
    <script>

        function walletModal(id,name){

            $('#wallet-name').html(name);
            $('#u_wallet_id').val(id);
            $('#modal-wallet').modal('show');

        }
                let loader = `@include('components.loader')`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/single/user/${id}/edit`);
                }

    </script>
@endpush


