@extends('layouts.tabler-vertical')
@section('title','Admin Settings')



@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Payments
                        </h2>
                    </div>
                    <!-- Page title actions -->


                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>user_id</th>
                                    <th>user_name</th>
                                    <th>amount</th>
                                    <th>transaction_id</th>
                                    <th>status</th>
                                    <th>created at</th>
                                    <th>updated at</th>
                                </tr>
                                </thead>
                                <tbody>


                                @foreach($payments as $payment)
                                    <tr>
                                        <td> {{ $payment->id }} </td>
                                        <td> {{ $payment->user_id }}  </td>
                                        <td> {{ $payment->user->name }}  </td>
                                        <td> {{ $payment->amount }}  </td>
                                        <td > #{{ $payment->transaction_id }}  </td>
                                        <td>

                                            @if($payment->status == "pending")
                                             <div class="text-yellow">
                                                 {{ $payment->status }}
                                             </div>
                                            @endif
                                                @if($payment->status == "canceled")
                                                    <div class="text-red">
                                                        {{ $payment->status }}
                                                    </div>
                                                @endif
                                                @if($payment->status == "completed")
                                                    <div class="text-green">
                                                        {{ $payment->status }}
                                                    </div>
                                                @endif

                                        </td>
                                        <td> {{ $payment->created_at }} </td>
                                        <td> {{ $payment->updated_at->diffForHumans() }} </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>





@endsection

@push('scripts')


@endpush
