@extends('layouts.tabler-vertical')
@section('title','Admin Settings')



@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            الإشعار
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                إرسال الإشعارات
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">
                        <h3> الإشعارات </h3>

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>المعرف</th>
                                    <th>العنوان</th>
                                    <th>الوصف</th>
                                    <th>الهدف</th>
                                    <th>التاريخ</th>
                                    <th>تاريخ التحديث</th>
                                    <th>الإجرائات</th>
                                </tr>
                                </thead>
                                <tbody>


                                @foreach($notifications as $notification)
                                    <tr>
                                        <td>{{ $notification->id }}</td>

                                        <td>  {{ $notification->title }}  </td>
                                        <td>  {{ $notification->description }}  </td>
                                        <td>
                                        @if($notification->type == "public")
                                           <span class="text-green"> للجميع</span>
                                        @else
                                             @if($notification->user_id)
                                                @if(\App\Models\User::find($notification->user_id))
                                                
                                                <span class="text-primary">{{\App\Models\User::find($notification->user_id)->name}}</span>
                                                @endif
                                            @endif    
                                                 
                                        @endif

                                        </td>
                                        <td>  {{ $notification->created_at->diffForHumans() }}</td>
                                        <td>  {{ substr($notification->updated_at,0,10) }}</td>
                                        <td>

                                            <button type="button"
                                                    onclick="deleteRecord('{{route("admin.notifications.destroy",["notification"=>$notification->id])}}')"
                                                    class="btn btn-danger">
                                                حذف
                                            </button>

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{--        modals--}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">إرسال إشعار جديد</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{route('admin.notifications.store')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body scrollable-modal">

                            @if(isset($user_id))
                                @php $tuser = \App\Models\User::find($user_id); @endphp
                                @if($tuser)
                                   <p class="text-red"> إرسال الإشعار إلى {{$tuser->name}} </p>
                                @endif
                            @endif

                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12  col-sm-12">
                                    <div class="form-group">
                                        <label>العنوان</label>
                                        <input class="form-control" type="text" name="title" placeholder="title">
                                        @error('title') <small
                                            class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label>الوصف</label>
                                        <textarea class="form-control" type="text" name="description" placeholder="description"></textarea>
                                        @error('description') <small class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>


                                @if(isset($user_id))
                                    <input class="form-control" type="text" name="user_id" value="{{$user_id}}" hidden >
                                    <input class="form-control" type="text" name="type" value="personal" hidden>
                                @else
                                    <input class="form-control" type="text" name="type" value="public" hidden>
                                @endif

                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">
                             إرسال
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @include('components.remove-modal')


        @endsection

        @push('scripts')

            <script>
                function deleteRecord(action) {

                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
        @endpush

