@extends('layouts.tabler-vertical')
@section('title','Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">

            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">


                        <h2 class="page-title">
                            طلاب الكورس
                        </h2>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>{{ __('admin.id') }}</th>
                                    <th>{{ __('admin.name') }}</th>
                                    <th> الكوبون </th>
                                    <th>نتيجة الامتحان</th>
                                    <th>{{ __('admin.created_at') }}</th>
                                    <th>{{ __('admin.updated_at') }}</th>
                                    <th>{{ __('admin.actions') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($students as $student)
                                    <tr>
                                        <td>{{ $student->id }}</td>
                                        <td>{{ $student->user->name }}</td>
                                        <td>{{ $student->code }}</td>
                                        <td>{{ $student->grade }}</td>

                                        <td>{{ $student->created_at->diffForHumans() }}</td>
                                        <td>{{ $student->updated_at->diffForHumans() }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false">
                                                    {{ __('admin.actions') }}
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end">


                                                    <a href="{{route('admin.students.generate.certificate',$student->id)}}" class="dropdown-item"  > توليد شهادة </a>
                                                    <a href="{{route('admin.students.final.exam',$student->id)}}" class="dropdown-item"  > الاختبار النهائي </a>
                                                    <button type="button" class="dropdown-item" onclick="edit('{{$student->id}}')"> تعديل نتيجة الاختبار </button>
                                                    <button type="button" onclick="deleteRecord('{{route("admin.students.destroy",["student"=>$student->id])}}')" class="dropdown-item">{{ __('admin.delete') }}</button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                                                <div class="row">
                                                    <div class="pagination">
                                                        {!! $students->links('pagination::bootstrap-4') !!}
                                                    </div>
                                                </div>

                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" id="edit-modal-content">

            </div>
        </div>
    </div>



    @include('components.remove-modal')
@endsection

@push('scripts')
    <script>

        const dropdowns = document.querySelectorAll('.dropdown-toggle')
        const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
            popperConfig(defaultBsPopperConfig) {
                return { ...defaultBsPopperConfig, strategy: 'fixed' };
            }
        }));

        let loader = `@include('components.loader')`;

        function edit(id) {
            $("#edit-modal-content").html(loader);
            $('#edit-modal').modal('show');
            $("#edit-modal-content").load(`admin/students/${id}/edit`);
        }


        function setDir(dir) {
            // Use querySelectorAll for more modern and efficient element selection
            const elements = document.querySelectorAll('.direc');

            if (elements.length === 0) {
                console.warn("No elements found with class 'direc'.");
                return; // Exit the function if no elements are found
            }

            if (dir.toLowerCase() === 'rtl') {
                elements.forEach(element => element.setAttribute('dir', 'rtl'));
            } else if (dir.toLowerCase() === 'ltr') {
                elements.forEach(element => element.setAttribute('dir', 'ltr'));
            } else {
                console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
            }
        }

        function deleteRecord(action) {
            console.log(action)
            $("#remove-form").attr('action', action);
            $("#modal-danger").modal('show');
        }

    </script>
@endpush
