<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <style type="text/css">

        *,::after,::before {
            box-sizing: border-box;
        }

        .a4-container {
            display: none;
            width:3508px ;
            height: 2480px;
            margin: 0;
            padding: 20mm;
        }

        body{
            margin: 0;
            font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,"Noto Sans","Liberation Sans",sans-serif,"Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol","Noto Color Emoji";
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            text-align: left;
            background-color: #e3e3e3;
        }

        /* Responsive container with max-width for fixed width content */
        .container {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
        }

        @media (min-width: 576px) {
            .container {
                max-width: 540px;
            }
        }
        @media (min-width: 768px) {
            .container {
                max-width: 720px;
            }
        }
        @media (min-width: 992px) {
            .container {
                max-width: 960px;
            }
        }
        @media (min-width: 1200px) {
            .container {
                max-width: 1140px;
            }
        }

        /* Full-width container for fluid layout */
        .container-fluid {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
        }
        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }
        .col-12 {
            flex: 0 0 100%;
            max-width: 100%;
        }

        .btn-download{
            height: 70px;
            padding: 10px 25px;
            background-color: #4263eb;
            color: #fff;
            border: none;
            border-radius: 10px;
            font-size: 24px ;
            font-family: sans-serif;
        }


        #hiddenDiv {
            display: none;
        }


        #progress-dialog {
            width: 90%;
            height: 400px;
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            z-index: 9999999;

            flex-direction: column;
            justify-content: center;
            align-items: center;

        }

        .spinner-container {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        .spinner {
            border: 8px solid rgba(0, 0, 255, 0.1);
            border-top: 8px solid #3498db;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

    </style>

    <title>Eb</title>
</head>
<body>

<div id="progress-dialog">
    <div class="spinner-container">
        <div class="spinner"></div>
    </div>
    <p> ... الرجاء الانتظار....</p>
</div>

<div class="container">
    <div class="row" style="text-align: center;display: block;background-color: #fff;padding: 20px;margin-top: 20px">
        <div>
            <img src="{{asset('logo.png')}}" width="170px">
        </div>
        <h1>المحكمة الافتراضية</h1>
        <p style="font-size: 22px">يمكنك تحميل الشهادة من هنا</p>
        <div id="hiddenDiv" >
            <button class="btn-download" id="download-btn" onclick="downloadCertificate()"> download certificate - تحميل الشهادة </button>
        </div>
        <div id="messaage" >
            الرجاء الانتظار....
        </div>

        <div id="success-messaage" style="display: none" >
            تم تحميل الشهادة بالتوفيق
        </div>

    </div>
</div>

<div class="a4-container" id="a4-container" style="background-position: center;background-size: cover;background-repeat: no-repeat;background-image: url('{{asset('certificate.jpg')}}');position: relative;">

    <h3 style="text-align: center;color:#fff; font-size: 117px;position: absolute;top:901px;left: 0;right: 0;">{{$user_name}}</h3>
    <p style="text-align: center;color:#fff;font-size: 100px;position: absolute;top:1400px;left: 0;right: 0;">{{$course_name}}</p>
    <p style="text-align: center;color:#fff;font-size: 70px;position: absolute;bottom:381px;left: 650px;"> {{$certificate_date}} </p>
    <p style="text-align: left;color:#fff;font-size: 60px;position: absolute;bottom:69px;left: 1150px;"> {{$certificate_url}} </p>

</div>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        // This function will be called after the page is fully loaded
        showHiddenDiv();
    });

    function showProgressDialog() {
        document.getElementById("progress-dialog").style.display = "flex";
    }

    function hideProgressDialog() {
        document.getElementById("progress-dialog").style.display = "none";
        document.getElementById("success-messaage").style.display = "block";
        document.getElementById("hiddenDiv").style.display = "none";

    }


    function showHiddenDiv() {
        // Get the hidden div element
        var hiddenDiv = document.getElementById("hiddenDiv");
        document.getElementById("messaage").remove();

        // Display the hidden div
        hiddenDiv.style.display = "block";

    }
</script>


<script src="{{asset('html2canvas.min.js')}}"></script>

<script>

    function  downloadCertificate(){
        showProgressDialog();
        const div = document.getElementById('a4-container');


        div.style.display ='block';

        const innerProgressBar = document.getElementById("inner-progress-bar");

        html2canvas(div,{
            onprogress: function (progress) {
                const percentage = Math.round((progress.loaded / progress.total) * 100);
                innerProgressBar.style.width = percentage + "%";
            }
        }).then(canvas => {
            div.style.display ='none';
            hideProgressDialog();
            const image = canvas.toDataURL('image/png');
            const link = document.createElement('a');
            link.href = image;
            link.download = '{{$user_name}}_cert.png';
            link.click();
        });
    }

</script>
</body>
</html>
