@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->
                        <h2 class="page-title">
                            @lang('admin.categories')
                        </h2>
                    </div>

                    <div class="col">
                        <a href="{{ route('admin.categories.index', ['cat_type' => '1']) }}"
                            class="btn btn-outline-warning ms-2">@lang('admin.workshops')</a>
                    </div>

                    <div class="col">
                        <a href="{{ route('admin.categories.index', ['cat_type' => '0']) }}"
                            class="btn btn-outline-success ms-2">@lang('admin.courses')</a>
                    </div>

                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                @lang('admin.add_new_category')
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th>@lang('admin.id')</th>
                                        <th>صورة التصنيف</th>
                                        <th>@lang('admin.name')</th>
                                        <th>نوع التصنيف</th>
                                        <th>التصنيف الأب</th>
                                        <th>@lang('admin.created_at')</th>
                                        <th>@lang('admin.updated_at')</th>
                                        <th>@lang('admin.actions')</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @foreach ($categories as $category)
                                        <tr>
                                            <td>{{ $category->id }}</td>
                                            <td>
                                                @if ($category->image)
                                                    <img src="{{ asset($category->image) }}" width="60">
                                                @endif

                                            </td>
                                            <td>{{ $category->name }}</td>
                                            <td>
                                                @if ($category->cat_type == 0)
                                                    تصنيف كورس
                                                @else
                                                    تصنيف ورشة
                                                @endif

                                            </td>

                                            <td>
                                                {{ $category->father_category ? $category->father_category->name : '' }}
                                            </td>

                                            <td>{{ $category->created_at->diffForHumans() }}</td>
                                            <td>{{ $category->updated_at->diffForHumans() }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    <button class="btn dropdown-toggle align-text-top"
                                                        data-bs-toggle="dropdown" aria-expanded="false">
                                                        @lang('admin.actions')
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-end" style="">
                                                        <button type="button" class="dropdown-item"
                                                            onclick="edit('{{ $category->id }}')">
                                                            @lang('admin.edit')
                                                        </button>

                                                        <button type="button"
                                                            onclick="deleteRecord('{{ route('admin.categories.destroy', ['category' => $category->id]) }}')"
                                                            class="dropdown-item">
                                                            @lang('admin.delete')
                                                        </button>

                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    @endforeach


                                </tbody>
                            </table>

                        </div>
                        {{--                        <div class="row"> --}}
                        {{--                            <div class="pagination"> --}}
                        {{--                                {!! $lots->links('pagination::bootstrap-4') !!} --}}
                        {{--                            </div> --}}
                        {{--                        </div> --}}
                    </div>

                </div>
            </div>
        </div>

        {{--        modals --}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"> @lang('admin.create_new_category') </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('admin.categories.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button" onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="4" y1="12" x2="14" y2="12" />
                                            <line x1="4" y1="18" x2="18" y2="18" />
                                        </svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="10" y1="12" x2="20" y2="12" />
                                            <line x1="6" y1="18" x2="20" y2="18" />
                                        </svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>@lang('admin.name')</label>
                                        <input class="form-control @error('name') is-invalid @enderror direc"
                                            type="text" name="name" placeholder="@lang('admin.name')">
                                        @error('name')
                                            <small class="form-text  text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label> صورة التصنيف </label>
                                        <input class="form-control @error('image') is-invalid @enderror direc"
                                            type="file" name="image" placeholder="صورة التصنيف">
                                        @error('image')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label> نوع التصنيف </label>
                                        <select class="form-select" id="cat_type" name="cat_type">
                                            <option value="0"> تصنيف كورس </option>
                                            <option value="1"> تصنيف ورشة </option>
                                        </select>
                                        @error('cat_type')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label> التصنيف الأب</label>
                                        <select class="form-select" id="father_category_id" name="father_category_id">
                                            <option selected value="0"> {{ 'بدون تصنيف أب' }} </option>

                                            @php
                                                $sub_categories = App\Models\Category::where('father_category_id', 0)->get();
                                            @endphp
                                            @foreach ($sub_categories as $sub_cat)
                                                <option value="{{ $sub_cat->id }}"
                                                    data-cat-type="{{ $sub_cat->cat_type }}">
                                                    {{ $sub_cat->name }}
                                                </option>
                                            @endforeach

                                        </select>
                                        @error('father_category_id')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>


                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto"
                                data-bs-dismiss="modal">@lang('admin.close')</button>
                            <button type="submit" class="btn btn-primary">
                                @lang('admin.create_category')
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal --}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
    @endsection

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                function filterFatherCategories() {
                    var selectedCatType = $('#cat_type').val(); // Get the selected value of the first dropdown
                    $('#father_category_id option').each(function() {
                        var optionCatType = $(this).data('cat-type'); // Get the cat_type value from data attribute

                        // Show/Hide options based on cat_type
                        if (selectedCatType == optionCatType || $(this).val() == "0") {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });

                    // Reset the selected option to the default one if the current value is hidden
                    if ($('#father_category_id option:selected').is(':hidden')) {
                        $('#father_category_id').val('0');
                    }
                }

                // Trigger filtering when the page loads
                filterFatherCategories();

                // Trigger filtering when #cat_type changes
                $('#cat_type').change(function() {
                    filterFatherCategories();
                });
            });
        </script>

        <script>
            const dropdowns = document.querySelectorAll('.dropdown-toggle')
            const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                popperConfig(defaultBsPopperConfig) {
                    return {
                        ...defaultBsPopperConfig,
                        strategy: 'fixed'
                    };
                }
            }));

            let loader = `@include('components.loader')`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/categories/${id}/edit`);
            }


            function setDir(dir) {
                // Use querySelectorAll for more modern and efficient element selection
                const elements = document.querySelectorAll('.direc');

                if (elements.length === 0) {
                    console.warn("No elements found with class 'direc'.");
                    return; // Exit the function if no elements are found
                }

                if (dir.toLowerCase() === 'rtl') {
                    elements.forEach(element => element.setAttribute('dir', 'rtl'));
                } else if (dir.toLowerCase() === 'ltr') {
                    elements.forEach(element => element.setAttribute('dir', 'ltr'));
                } else {
                    console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                }
            }
        </script>
        <script>
            function deleteRecord(action) {
                console.log(action)
                $("#remove-form").attr('action', action);
                $("#modal-danger").modal('show');
            }
        </script>
    @endpush
