<div class="modal-header">
    <h5 class="modal-title">@lang('admin.edit_category')</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form action="{{ route('admin.categories.update', ['category' => $category->id]) }}" method="post"
    enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="modal-body scrollable-modal">

        <div class="row mt-3">

            <div class="col-12 ">

                <button type="button" onclick="setDir('ltr')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="4" y1="12" x2="14" y2="12" />
                        <line x1="4" y1="18" x2="18" y2="18" />
                    </svg>
                </button>
                <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="10" y1="12" x2="20" y2="12" />
                        <line x1="6" y1="18" x2="20" y2="18" />
                    </svg>
                </button>

            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>@lang('admin.name')</label>
                    <input class="form-control @error('name') is-invalid @enderror direc" type="text" name="name"
                        placeholder="@lang('admin.name')" value="{{ $category->name }}">
                    @error('name')
                        <small class="form-text  text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> صورة التصنيف </label>
                    <input class="form-control @error('image') is-invalid @enderror direc" type="file" name="image"
                        placeholder="صورة التصنيف">
                    @error('image')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror

                    @if ($category->image)
                        <img src="{{ asset($category->image) }}" width="60">
                    @endif
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> نوع التصنيف </label>
                    <select class="form-select" id="cat_type_1" name="cat_type">
                        <option @if ($category->cat_type == 0) selected @endif value="0"> تصنيف كورس </option>
                        <option @if ($category->cat_type == 1) selected @endif value="1"> تصنيف ورشة </option>
                    </select>
                    @error('cat_type')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> التصنيف الأب</label>
                    <select class="form-select" id="father_category_id_1" name="father_category_id">

                        <option @if (!$category->father_category) selected @endif value="0">
                            {{ 'بدون تصنيف أب' }}
                        </option>

                        @php
                            $sub_categories = App\Models\Category::where('father_category_id', 0)->get();
                        @endphp

                        @foreach ($sub_categories as $sub_cat)
                            <option @if ($category->father_category_id == $sub_cat->id) selected @endif value={{ $sub_cat->id }}
                                data-cat-type="{{ $sub_cat->cat_type }}">
                                {{ $sub_cat->name }}
                            </option>
                        @endforeach

                    </select>
                    @error('father_category_id')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

        </div>


    </div>
    <div class="modal-footer">
        <button type="button" class="btn me-auto" data-bs-dismiss="modal"> @lang('admin.close') </button>
        <button type="submit" class="btn btn-primary"> @lang('admin.save_changes') </button>
    </div>
</form>


<script>
    changeTypes();

    function changeTypes() {
        var selectedCatType = $('#cat_type_1').val();

        $('#father_category_id_1 option').each(function() {
            var optionCatType = $(this).data('cat-type'); // Get the cat_type value from data attribute

            // Show/Hide options based on cat_type
            if (selectedCatType == optionCatType || $(this).val() == "0") {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    }

    $('#cat_type_1').change(function(e) {
        e.preventDefault();
        changeTypes();
    });
</script>
