<?php

namespace App\Services;

use App\Http\Helpers\SettingHelper;
use Illuminate\Support\Facades\Http;

class OtpService
{


    public function sendWhatsAppMessage($recipient, $message, $type = 'text')
    {
        $apiUrl = 'https://sms.dr-social.com/api/send/whatsapp';
        $account = SettingHelper::getSetting('whats_app_device');
        $secret = SettingHelper::getSetting('api_access');

        // Making a POST request using the Http facade
        $response = Http::asForm()->post($apiUrl, [
            'account'   => $account,
            'secret'    => $secret,
            'message'   => $message,
            'type'      => $type,
            'recipient' => $recipient,
        ]);

        // Handling the response
        if ($response->successful()) {
            return $response->json();  // Successful response
        }

        return $response->body();  // Error response
    }



    public function sendSmsOTP($phone, $message, $type = 'text', $priority = 1, $sim = 1, $mode = 'devices')
    {
        $apiUrl = 'https://sms.dr-social.com/api/send/sms';
        $device = SettingHelper::getSetting('sms_device');
        $secret = SettingHelper::getSetting('api_access');

        // Sending POST request
        $response = Http::asForm()->post($apiUrl, [
            'device'   => $device,
            'secret'   => $secret,
            'message'  => $message,
            'type'     => $type,
            'phone'    => $phone,
            'priority' => $priority,
            'sim'      => $sim,
            'mode'     => $mode,
        ]);

        // Handle the response
        if ($response->successful()) {
            return $response->json();  // Return decoded JSON response
        }

        return $response->body();  // Return error response
    }
}
