<?php


namespace App\Services;



use App\Http\Helpers\MainHelper;

class FCMService
{

    public static function sendNotification($topic, $title, $body) {
        $accessToken = MainHelper::getAccessToken();

        $url = 'https://fcm.googleapis.com/v1/projects/virtual-court-aad4c/messages:send';
        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json',
        ];

        $postData = [
            "message" => [
                "topic" => $topic,
                "notification" => [
                    "title" => $title,
                    "body" => $body,
                ],
                "android" => [
                    "notification" => [
                        "channel_id" => "high_importance_channel",
                        "sound" => "default",
                    ],
                ],
            ],
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }


    public static function sendDataNotification($topic, $data) {
        $accessToken = MainHelper::getAccessToken();

        $url = 'https://fcm.googleapis.com/v1/projects/virtual-court-aad4c/messages:send';
        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json',
        ];

        $postData = [
            "message" => [
                "topic" => $topic,
                "data" => $data,
            ],
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

}
