<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Workshop extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'category_id',
        'name',
        'image',
        'description',
        'pdf',
        'long_video',
        'short_video',
        'price',
        'discount',
        'is_free',
        'is_active',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function author()
    {
        return $this->belongsTo(User::class);
    }
    public function students()
    {
        return $this->hasMany(Student::class);
    }

    public function is_student()
    {
        return $this->hasMany(Student::class)->where('user_id', auth('api')->id());
    }
    public function is_rated()
    {
        return $this->hasMany(Rate::class)->where('user_id', auth('api')->id());
    }
}
