<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory;


    protected $fillable = [
        'user_id',
        'category_id',
        'name',
        'description',
        'image',
        'is_free',
        'is_active',
        'price',
        'discount',
        'hours',
        'pdf',
        'is_exam_active',
        'promo_link',
        'rate',
        'author_id'
    ];

    public function category(){
        return $this->belongsTo(Category::class);
    }
    public function author(){
        return $this->belongsTo(User::class);
    }
      public function students(){
        return $this->hasMany(Student::class);
    }

    public function is_student(){
        return $this->hasMany(Student::class)->where('user_id',auth('api')->id());
    }
    public function is_rated(){
        return $this->hasMany(Rate::class)->where('user_id',auth('api')->id());
    }

      public function course_contents(){
        return $this->hasMany(CourseContent::class);
    }
}
