<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    use HasFactory;

    public function father_category(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'father_category_id');
    }

    /**
     * Get all of the children_categories for the Category
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function children_categories(): HasMany
    {
        return $this->hasMany(Category::class, 'father_category_id', 'id');
    }


    /**
     * Get all of the courses for the Category
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function courses(): HasMany
    {
        return $this->hasMany(Course::class, 'category_id');
    }

    /**
     * Get all of the workshops for the Category
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function workshops(): HasMany
    {
        return $this->hasMany(Workshop::class, 'category_id');
    }
}
