<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CustomerMiddleware
{

    public function handle(Request $request, Closure $next)
    {
        if (!auth()->check()) {
            $t = Str::after(url()->current(), url('/'));
            return redirect()->route('login')->with('target', $t);
        }

        return $next($request);
    }
}
