<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\Report;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function storeReport(Request $request){
        $validator = validator()->make($request->all(),[

            'email'=> 'required|email',
            'report'=> 'required',

        ]);

        if($validator->fails()){
            return response()->json(['message' => $validator->errors()->first() ],403);
        }

        Report::create([
            'email'=>$request->email,
            'report'=>$request->report,
        ]);

        return response()->json(['message'=>'report sent successfully']);

    }
 }
