<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\PullGame;
use App\Models\PullGameOption;
use App\Services\FCMService;
use Illuminate\Http\Request;

class PullController extends Controller
{

    public function index(){


        $pull = PullGame::with(['pullGameOptions'])->orderBy('id','DESC')->get()->first();

        if ($pull) {
            $pullGameOptions = $pull->pullGameOptions->toArray(); // Convert collection to array
            shuffle($pullGameOptions);
            $pull->pullGameOptions = $pullGameOptions; // Update the property with shuffled array
        }

        return response()->json($pull);

    }

    public function openOption($id){

        $pullOption = PullGameOption::findOrFail($id);
        $pull = PullGame::findOrFail($pullOption->pull_game_id);
        $user = auth('api')->user();

        if($user->wallet < $pull->price){
            return response()->json(['message'=>'no enough balance'],403);
        }


        if($pullOption->user_id != null){
            return response()->json(['message'=>'this choice is already taken by another one.'],403);
        }


        $pullOption->user_id = $user->id;
        $pullOption->save();

        $user->wallet = $user->wallet - $pull->price;
        $user->save();


        $data = [
            "type" => "open_choise",
            "option_id" => $pullOption->id."",
            "user_id" => $user->id."",
        ];
        FCMService::sendDataNotification("public",$data);


        return response()->json(['message'=>'completed']);

    }

}
