<?php

namespace App\Http\Controllers\api\v1;

use App\App_CourseResource;
use App\Http\Controllers\Controller;
use App\Http\Helpers\MainHelper;
use App\Http\Helpers\SettingHelper;
use App\Models\Course;
use App\Models\UserNotification;
use App\Models\Workshop;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use App\Models\Rate;
use App\Models\CourseContent;
use App\Models\QuestionAnswer;
use App\Models\Student;
use App\Models\CouponCode;
use App\Models\QuizQuestion;
use App\Models\UserAnswer;
use App\Models\TextQuestion;
use App\Models\Certificate;
use App\Models\Discussion;
use App\Models\JoinReq;
use App\Models\Category;

class LotController extends Controller
{

    public function categoryWorkshops($id)
    {

        $top_workshops = Workshop::where('is_active', 1)->where('category_id', $id)->with(['author:id,name,image,bio', 'category.father_category:id,name'])
            ->withCount('students')
            ->withCount('is_student')
            ->withCount('is_rated')
            ->orderBy('id', 'DESC')->get();

        return response()->json($top_workshops);
    }



    public function categoryCourses(Request $request, $id)
    {

        $type = $request->type;
        $iphone = (isset($type) && $type == 'i') ? true : false;

        $courses = Course::where('is_active', 1)->where('category_id', $id)
            ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
            ->withCount('students')
            ->withCount('is_student')
            ->withCount('is_rated')
            ->withCount('course_contents')->orderByDesc('id')
            ->get()
            ->when($iphone, function ($courses) {
                return $courses->map(function ($course) {
                    $course->is_free = 1;
                    $course->price = 0;

                    return $course;
                });
            });
        ;

        return response()->json($courses);

    }

    public function storeCourseRequest(Request $request)
    {
        $checkCount = JoinReq::where('course_id', $request->course_id)->where('user_id', auth('api')->user()->id)->count();

        if ($checkCount > 0) {
            return response()->json(['message' => 'لديك طلب انضمام سابق لهذا الكورس وهو قيد المراجعة '], 403);
        }
        $re = new JoinReq();
        $course = Course::findOrFail($request->course_id);
        //update
        if ($request->coupon_code) {
            $isValidCoupon = CouponCode::where('course_id', $request->course_id)->where('coupon', $request->coupon_code)->count();
            if ($isValidCoupon == 0) {
                return response()->json(['message' => 'invalid coupon code'], 403);
            }

            $cop = CouponCode::where('course_id', $request->course_id)->where('coupon', $request->coupon_code)->first();

            if ($cop->apply_count >= $cop->allowed_apply_count) {
                return response()->json(['message' => 'invalid coupon code'], 403);
            }
            $cop->apply_count = $cop->apply_count + 1;
            $cop->save();

            $re->coupon_code = $request->coupon_code;
            $re->discount = $cop->discount;
        }


        $re->course_id = $request->course_id;
        $re->user_id = auth('api')->user()->id;
        $re->item_price = $course->price;
        $re->message = $request->message;
        $re->type = 'course';
        $re->save();

        return response()->json(['message' => 'تم إرسال الطلب بنجاح وهو قيد المراجعة'], 200);
    }
    public function storeWorkShopRequest(Request $request)
    {
        $checkCount = JoinReq::where('workshop_id', $request->workshop_id)->where('user_id', auth('api')->user()->id)->count();

        if ($checkCount > 0) {
            return response()->json(['message' => 'لديك طلب انضمام سابق لهذه الورشة وهو قيد المراجعة '], 403);
        }

        $re = new JoinReq();
        $workshop = Workshop::findOrFail($request->workshop_id);
        //update
        if ($request->coupon_code) {
            $isValidCoupon = CouponCode::where('workshop_id', $request->workshop_id)->where('coupon', $request->coupon_code)->count();
            if ($isValidCoupon == 0) {
                return response()->json(['message' => 'invalid coupon code'], 403);
            }

            $cop = CouponCode::where('workshop_id', $request->workshop_id)->where('coupon', $request->coupon_code)->first();

            if ($cop->apply_count >= $cop->allowed_apply_count) {
                return response()->json(['message' => 'invalid coupon code'], 403);
            }
            $cop->apply_count = $cop->apply_count + 1;
            $cop->save();

            $re->coupon_code = $request->coupon_code;
            $re->discount = $cop->discount;
        }

        $re->workshop_id = $request->workshop_id;
        $re->user_id = auth('api')->user()->id;
        $re->message = $request->message;
        $re->type = 'workshop';
        $re->item_price = $workshop->price;
        $re->save();

        return response()->json(['message' => 'تم إرسال الطلب بنجاح وهو قيد المراجعة'], 200);
    }

    public function createJoinReq(Request $request)
    {

        $validator = validator()->make($request->all(), [
            'course_id' => 'required',
            'workshop_id' => 'required',
            'message' => 'required|string',
            'type' => 'required|string|in:course,workshop',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        if ($request->type == "course") {
            return $this->storeCourseRequest($request);
        } else {
            return $this->storeWorkShopRequest($request);
        }

    }

    public function deleteDiscuss($id)
    {
        $discuss = Discussion::findOrFail($id);
        $course = Course::findOrFail($discuss->course_id);

        if ($discuss->user_id == auth('api')->user()->id || $course->author_id == auth('api')->user()->id) {
            $discuss->delete();
            return response()->json(['message' => 'removed']);
        }

        return response()->json(['message' => 'you cant remove this message'], 403);

    }


    public function storeDiscuss(Request $request)
    {

        $validator = validator()->make($request->all(), [
            'course_id' => 'required|exists:courses,id',
            'message' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $discussion = Discussion::create([
            'course_id' => $request->course_id,
            'user_id' => auth()->id(),
            'message' => $request->message,
        ]);
        $discussion = Discussion::with(['user:id,name,image'])->find($discussion->id);

        return response()->json($discussion);
    }

    public function getDiscuss($course_id)
    {

        $discussions = Discussion::with(['user:id,name,image'])->where('course_id', $course_id)->get();
        return response()->json($discussions);
    }




    public function getMyCertificates()
    {

        $user = auth('api')->user();

        $certs = Certificate::with(['course', 'workshop'])->where('user_id', $user->id)->orderBy('id', 'DESC')->get();

        return response()->json($certs);

    }


    public function search($keyword, $t)
    {
        $arr = [];

        // If both courses and workshops are requested
        if ($t == "poth") {
            // Get courses matching the keyword
            $courses = Course::where('is_active', 1)->where('name', 'like', '%' . $keyword . '%')
                ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                ->withCount('students')
                ->withCount('is_student')
                ->withCount('is_rated')
                ->withCount('course_contents')
                ->orderBy('id', 'desc')
                ->get();

            // Get workshops matching the keyword
            $workshops = Workshop::where('is_active', 1)->where('name', 'like', '%' . $keyword . '%')
                ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                ->withCount('students')
                ->withCount('is_student')
                ->withCount('is_rated')
                ->orderBy('id', 'desc')
                ->get();

            // Merge both results into a single array
            $arr = array_merge($courses->toArray(), $workshops->toArray());

            // If only courses are requested
        } elseif ($t == "course") {
            $courses = Course::where('is_active', 1)->where('name', 'like', '%' . $keyword . '%')
                ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                ->withCount('students')
                ->withCount('is_student')
                ->withCount('is_rated')
                ->withCount('course_contents')
                ->orderBy('id', 'desc')
                ->get();

            // Add the courses to the result array
            $arr = $courses->toArray();

            // If only workshops are requested
        } else {
            $workshops = Workshop::where('is_active', 1)->where('name', 'like', '%' . $keyword . '%')
                ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                ->withCount('students')
                ->withCount('is_student')
                ->withCount('is_rated')
                ->orderBy('id', 'desc')
                ->get();

            // Add the workshops to the result array
            $arr = $workshops->toArray();
        }

        // Return the final result as a JSON response
        return response()->json($arr);
    }


    public function applyWorkShopCode(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'code' => 'required|string',
            'work_shop_id' => 'required|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $workShop = Course::findOrFail($request->work_shop_id);

        $checker = CouponCode::where('workshop_id', $request->work_shop_id)->where('coupon', $request->code)->count();
        if ($checker == 0) {
            return response()->json(['message' => "كود غير صالح"], 403);
        }
        $currentCode = CouponCode::where('workshop_id', $request->work_shop_id)->where('coupon', $request->code)->first();

        if ($currentCode->apply_count >= $currentCode->allowed_apply_count) {
            return response()->json(['message' => "لم يعد هذا الكود صالحا للاستخدام"], 403);
        }

        $currentCode->apply_count = $currentCode->apply_count + 1;
        $currentCode->save();

        $student = new Student();
        $student->user_id = auth('api')->id();
        $student->workshop_id = $request->work_shop_id;
        $student->code = $request->code;
        $student->save();
        return response()->json(['message' => "تم تنفيذ الكود بنجاح"], 200);
    }


    public function rateCourse(Request $request)
    {
        $course_id = $request->course_id;
        $course = Course::findOrFail($course_id);

        $isStudent = Student::where('course_id', $request->course_id)->where('user_id', auth('api')->id())->count();

        if ($isStudent == 0) {
            return response()->json(['message' => 'لا يمكنك تقييم هذا الكورس'], 403);
        }

        $isRated = Rate::where('course_id', $course_id)->where('user_id', auth('api')->id())->count();


        if ($isRated != 0) {
            return response()->json(['message' => 'لقد قمت بتقييم هذا الكورس سابقاًَ'], 403);
        }

        $rateMode = new Rate();
        $rateMode->user_id = auth('api')->id();
        $rateMode->course_id = $course_id;
        $rateMode->opinion = $request->rate_text;
        $rateMode->rating = $request->rate;
        $rateMode->save();

        $ratersCount = Rate::where('course_id', $course_id)->count();
        $ratersSum = Rate::where('course_id', $course_id)->sum('rating');

        $finalRate = 0.0;
        if ($ratersCount > 0) {
            $finalRate = $ratersSum / $ratersCount;
        }

        $course->rate = $finalRate;
        $course->save();
        return response()->json(['message' => 'لقد قمت بتقييم هذا الكورس'], 200);
    }



    public function getStudentResult($id)
    {

        $user = auth('api')->user();
        $student = Student::where('course_id', $id)->where('user_id', $user->id)->first();
        if (!$student) {
            return response()->json(['grade' => ''], 403);
        }
        return response()->json(['grade' => $student->grade], 200);
    }


    public function answerFinalQuestions(Request $request)
    {

        foreach ($request->answers as $answer) {
            $a = UserAnswer::where('id', $answer['id'])->first();
            $a->answer = $answer['answer'];
            $a->save();
        }
        return response()->json(['message' => "تمت العملية بنجاح"], 200);
    }


    public function getFinalExam($id)
    {

        $questions = TextQuestion::where('course_id', $id)->orderBy('id', 'ASC')->get();


        $exist = UserAnswer::where('course_id', $id)->where('user_id', auth('api')->id())->count();

        if ($exist == 0) {
            foreach ($questions as $q) {
                $ua = new UserAnswer();
                $ua->course_id = $id;
                $ua->question_id = $q->id;
                $ua->user_id = auth('api')->id();
                $ua->question = $q->question;
                $ua->save();
            }
        }
        $qs = UserAnswer::where('course_id', $id)->where('user_id', auth('api')->id())->get();

        return response()->json($qs);

    }


    public function applyCode(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'code' => 'required|string',
            'course_id' => 'required|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $course = Course::findOrFail($request->course_id);

        $checker = CouponCode::where('course_id', $request->course_id)->where('coupon', $request->code)->count();
        if ($checker == 0) {
            return response()->json(['message' => "كود غير صالح"], 403);
        }

        $currentCode = CouponCode::where('course_id', $request->course_id)->where('coupon', $request->code)->first();

        if ($currentCode->apply_count >= $currentCode->allowed_apply_count) {
            return response()->json(['message' => "لم يعد هذا الكود صالحا للاستخدام"], 403);
        }

        $currentCode->apply_count = $currentCode->apply_count + 1;
        $currentCode->save();

        $student = new Student();
        $student->user_id = auth('api')->id();
        $student->course_id = $request->course_id;
        $student->code = $request->code;
        $student->save();
        return response()->json(['message' => "تم تنفيذ الكود بنجاح"], 200);
    }




    public function quizQuestions($id)
    {
        $questions = QuizQuestion::where('course_test_id', $id)->get();
        return response()->json($questions);
    }


    public function myCourses()
    {

        $courseIds = Student::where('course_id', '!=', null)->where('user_id', auth('api')->id())->pluck('course_id');

        $courses = Course::where('is_active', 1)->whereIn('id', $courseIds)->with(['author:id,name,image,bio', 'category.father_category:id,name'])
            ->withCount('students')
            ->withCount('is_student')
            ->withCount('is_rated')
            ->withCount('course_contents')
            ->orderBy('id', 'desc')
            ->get();

        return response()->json(
            $courses
        );

    }


    public function index(Request $request)
    {
        $type = $request->type;
        $iphone = (isset($type) && $type == 'i') ? true : false;

        // $top_workshops = Workshop::where('is_active', 1)->with(['author:id,name,image,bio', 'category.father_category:id,name'])
        //     ->withCount('students')
        //     ->withCount('is_student')
        //     ->withCount('is_rated')
        //     ->orderBy('id', 'DESC')->get();
        // $top_courses = Course::where('is_active', 1)->with(['author:id,name,image,bio', 'category.father_category:id,name'])
        //     ->withCount('students')
        //     ->withCount('is_student')
        //     ->withCount('course_contents')
        //     ->withCount('is_rated')
        //     ->orderBy('id', 'DESC')->get();

        $notReadNotification = UserNotification::where('user_id', auth('api')->id())->where('is_read', 0)->count();

        $courses_sections = Category::select('id', 'cat_type', 'name', 'father_category_id')
            ->where('father_category_id', 0)
            ->where('cat_type', 0)
            ->with([
                'children_categories' => function ($query) {
                    $query->select('id', 'name', 'image', 'father_category_id', 'cat_type')
                        ->orderBy('id', 'desc');
                },

            ])
            ->get()
            ->map(function ($category) use ($iphone) {
                // Collect all courses for children_categories
                $top_courses = $category->children_categories
                    ->flatMap(function ($child) use ($iphone) {
                    return $child->courses()
                        ->where('is_active', 1)
                        // ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                        ->with('author')
                        ->with('category.father_category')
                        ->withCount('students')
                        ->withCount('is_student')
                        ->withCount('course_contents')
                        ->withCount('is_rated')
                        ->orderBy('id', 'desc')
                        ->get()
                        ->when($iphone, function ($courses) {
                            return $courses->map(function ($course) {

                                $course->is_free = 1;
                                $course->price = 0;

                                return $course;
                            });
                        });

                });

                // Attach courses to the parent category
                $category->top_courses = App_CourseResource::collection($top_courses);

                return $category;
            });

        $workshops_sections = Category::select('id', 'cat_type', 'name', 'father_category_id')
            ->where('father_category_id', 0)
            ->where('cat_type', 1)
            ->with([
                'children_categories' => function ($query) {
                    $query->select('id', 'name', 'image', 'father_category_id', 'cat_type')
                        ->orderBy('id', 'desc');
                },

            ])
            ->get()
            ->map(function ($category) {
                // Collect all courses for children_categories
                $top_workshops = $category->children_categories
                    ->flatMap(function ($child) {
                    return $child->workshops()
                        ->where('is_active', 1)
                        ->with(['author:id,name,image,bio', 'category.father_category:id,name'])
                        ->withCount('students')
                        ->withCount('is_student')
                        ->withCount('is_rated')
                        ->orderBy('id', 'desc')->get();
                });

                // Attach courses to the parent category
                $category->top_workshops = $top_workshops;

                return $category;
            });

        return response()->json(
            [
                'courses_sections' => $courses_sections,
                'workshops_sections' => $workshops_sections,
                // 'courses_categories' => $coursesCategories,
                // 'workshops_categories' => $workshopsCategories,
                // 'top_workshops' => $top_workshops,
                // 'top_courses ' => $top_courses,
                'not_read_notifications ' => $notReadNotification,
            ]
        );
    }

    public function raters($courseId)
    {

        $rates = Rate::where('course_id', $courseId)->with('user:id,name,image')->orderByDesc('id')->get();
        return response()->json(
            $rates
        );

    }

    public function content($courseId)
    {
        $courseContents = CourseContent::where('course_id', $courseId)->get();
        $arr = [];
        foreach ($courseContents as $item) {
            if ($item->contentable->active == 1) {
                $arr[] = $item->contentable;
            }
        }
        return response()->json(
            $arr
        );
    }


    public function questions()
    {
        $questions = QuestionAnswer::orderBy('id', 'ASC')->get();

        return response()->json($questions);
    }



    public function categoryParents(Request $request)
    {
        $categoryParents = Category::where('father_category_id', 0)
            ->with(['children_categories:id,name,image,father_category_id,cat_type'])
            ->get();

        return response()->json($categoryParents);
    }


}
