<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use App\Models\Category;
use App\Models\CouponCode;
use App\Models\Workshop;
use App\Models\Student;
use App\Services\FCMService;
use App\Models\User;
use App\Models\Notification;
use App\Models\JoinReq;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class WorkshopController extends Controller
{

   public function joinReqs($id){

        $joinreqs = JoinReq::where('workshop_id',$id)->with(['user:id,name,image'])->orderBy('id','DESC')->paginate(15);
        $workshop = Workshop::findOrFail($id);



        return view('admin.workshops.join_reqests')->with('workshop',$workshop)->with('joinreqs',$joinreqs);

    }

    public function toggleWorkshop($id,$state){


        $workshop = Workshop::findOrFail($id);
        $workshop->is_active = $state;
        $workshop->save();

        if($state == '0'){

             Alert::toast('Workshop was hidden successfully', 'success');
        }else{

            $notification = Notification::create([
                'type' => 'public',
                'title' =>  "المحكمة الافتراضية",
                'description' => "تم نشر ورشة جديدة",
            ]);
            $users = User::all();
            foreach ($users as $user) {
                $user->notifications()->attach($notification->id);
            }
            FCMService::sendNotification('public',"المحكمة الافتراضية",  "تم نشر ورشة جديدة");
            Alert::toast('Workshop actived successfully', 'success');

        }

        return redirect()->route('admin.workshops.index');

    }


    public function studentList($id){

        $students = Student::where('workshop_id',$id)->with(['user:id,name,image'])->paginate(15);
        return view('admin.workshops.students')->with('students',$students);

    }

    public function index()
    {
        $workshops = Workshop::orderBy('id', 'desc')->with('user')->paginate(12);
        $categories = Category::select('id', 'name', 'cat_type', 'father_category_id')
        ->where('father_category_id', '!=', '0')
        ->where('cat_type', '1')
        ->get();
        return view('admin.workshops.index')->with(['workshops' => $workshops, 'categories' => $categories]);
    }


    public function create()
    {
        // You can return a view for creating a new workshop
    }


    public function store(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',

            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'pdf' => 'nullable|mimes:pdf',

            'is_free' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $workshop = new Workshop();
        $workshop->user_id = auth()->id();
        $workshop->category_id = $request->category_id;
        $workshop->name = $request->name;
        $workshop->description = $request->description;
        $workshop->price = $request->price;

        $workshop->is_free = $request->is_free;

        if ($request->hasFile('image')) {
            $workshop->image = ImageHelper::storeImage('workshops/', $request->image);
        }

        if ($request->hasFile('pdf')) {
            $workshop->pdf = ImageHelper::storeImage('files/workshops/pdf/', $request->pdf);
        }

        $workshop->save();




        $path ='Virtual Court/workshop/w_'.$workshop->id;

        // Check if the folder already exists
        if (!Storage::disk('s3')->exists($path)) {
            Storage::disk('s3')->makeDirectory($path);
        }





        Alert::toast('Workshop created successfully', 'success');
        return redirect()->route('admin.workshops.index');
    }


    public function show(Workshop $workshop)
    {
        $couponCodes = CouponCode::where('workshop_id',$workshop->id)->orderBy('id','desc')->get();
        return view('admin.coupons.index', compact('couponCodes','workshop'));
    }


    public function edit(Workshop $workshop)
    {
        $categories = Category::select('id', 'name', 'cat_type', 'father_category_id')
        ->where('father_category_id', '!=', '0')
        ->where('cat_type', '1')
        ->get();
        return view('admin.workshops.edit')->with(['workshop' => $workshop, 'categories' => $categories]);
    }


    public function update(Request $request, Workshop $workshop)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',

            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'pdf' => 'nullable|mimes:pdf',
            'long_video' => 'required|string',
            'short_video' => 'nullable|string',
            'is_free' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $workshop->name = $request->name;
        $workshop->description = $request->description;
        $workshop->price = $request->price;

        $workshop->long_video = $request->long_video;
        $workshop->short_video = $request->short_video;
        $workshop->is_free = $request->is_free;

        if ($request->hasFile('image')) {
            $workshop->image = ImageHelper::storeImage('workshops/', $request->image);
        }

        if ($request->hasFile('pdf')) {
            $workshop->pdf = ImageHelper::storeImage('files/workshops/pdf/', $request->pdf);
        }

        $workshop->save();

        Alert::toast('Workshop updated successfully', 'success');
        return redirect()->route('admin.workshops.index');
    }


    public function destroy(Workshop $workshop)
    {
        $workshop->delete();
        Alert::toast('Workshop deleted successfully', 'success');
        return redirect()->route('admin.workshops.index');
    }
}
