<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TextQuestion;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class TextQuestionController extends Controller
{

    public function index()
    {

    }


    public function create()
    {

    }


    public function store(Request $request)
    {
        $validator = validator()->make($request->all(), [

            'question'=>'required|string',
            'course_id'=>'required|integer',

        ]);
        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $question = new TextQuestion();
        $question->course_id = $request->course_id;
        $question->question = $request->question;
        $question->save();

        Alert::toast('new question created successfully','success');
        return redirect()->route('admin.courses.exam',$request->course_id);

    }


    public function show(TextQuestion $textQuestion)
    {

    }


    public function edit(TextQuestion $textQuestion)
    {
        return view('admin.courses.exam.edit')->with('question',$textQuestion);
    }


    public function update(Request $request, TextQuestion $textQuestion)
    {
        $validator = validator()->make($request->all(), [
            'question'=>'required|string',
        ]);
        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $textQuestion->question = $request->question;
        $textQuestion->save();

        Alert::toast('question updated successfully','success');
        return redirect()->route('admin.courses.exam',$textQuestion->course_id);
    }


    public function destroy(TextQuestion $textQuestion)
    {
        $id = $textQuestion->course_id;
        $textQuestion->delete();
        Alert::toast('question deleted successfully','success');
        return redirect()->route('admin.courses.exam',$id);
    }
}
