<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Certificate;
use App\Models\Student;
use App\Models\User;
use App\Models\UserAnswer;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class StudentController extends Controller
{
    
    public function generateCert($id){

        $student = Student::findOrFail($id);

        $date=date('y-m-d');

        $user_name = User::findOrFail($student->user_id)->name;

        $student_id = $student->user_id;

        $isgenerated = Certificate::where('course_id',$student->course_id)->where('user_id',$student_id)->count(); 
        if( $isgenerated > 0 ){
            Alert::toast('this student already has this certificate', 'error');
            return redirect()->back();
        } 
        $code = mt_rand(100000, 999999) . $student_id . mt_rand(100000, 999999); 
        $image_name = time() . $student_id . $code . '.png';
 
        $certificate = new Certificate();
        $certificate->user_id = $student_id;
        if($student->course_id){
            $certificate->course_id  = $student->course_id;
        }else{
            $certificate->workshop_id    = $student->workshop_id;
        }

        $certificate->number     = $code;
        $certificate->image      =  'cert/'.$image_name;
        $certificate->save();

        Alert::toast('certificate generated successfully', 'success');
        return redirect()->back();
    }

     
    public function index()
    {
     
    }

    public function finalExam($id){
   
         $student = Student::findOrFail($id);
         $questions = UserAnswer::where('course_id',$student->course_id)->where('user_id',$student->user_id)->orderBy('id','ASC')->get(); 
         return view('admin.courses.students.exam')->with('questions',$questions); 
         
    }
 
    public function create()
    {
     
    }

     
    public function store(Request $request)
    {
  
    }

  
    public function show(Student $student)
    {
     
    }


    public function edit(Student $student)
    {
        return view('admin.courses.students.edit')->with('student',$student);
    }


    public function update(Request $request, Student $student)
    {
        $student->grade = $request->grade;
        $student->save();
        Alert::toast('student updated successfully', 'success');
        return redirect()->back();
    }

   
    public function destroy(Student $student)
    {
        $student->delete();
        Alert::toast('Student removed successfully', 'success');
        return redirect()->back();
    }
}
