<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\SettingHelper;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use RealRashid\SweetAlert\Facades\Alert;

class SettingController extends Controller
{

    public function index(Request $request)
    {
        $type = $request->type;
        //       abort_if(!auth()->user()->hasPermission('read setting'),403,"you dont have permission to access this page");
        $settings = Setting::where('key', '!=', 'about');

        if ($type) {
            $settings = $settings->where('type', $type);
        }

        $settings = $settings->get();

        return view('admin.settings.index')->with('settings', $settings);
    }


    public function create()
    {

    }


    public function store(Request $request)
    {

        //   abort_if(!auth()->user()->hasPermission('create setting'),403,"you dont have permission to access this page");


        $request->validate(['key' => 'required', 'value' => 'required']);

        $setting = new Setting();
        $setting->key = $request->key;
        $setting->value = $request->value;

        $setting->type = $request->type;
        $setting->description = $request->description;

        $setting->save();
        Alert::toast('new setting created successfully', 'success');
        return redirect()->route('admin.settings.index');

    }


    public function show($id)
    {

    }
    public function showAbout()
    {
        $about = SettingHelper::getSetting("about");

        return view('admin.about.index')->with('about', $about);
    }
    public function storeAbout(Request $request)
    {
        SettingHelper::updateSetting("about", $request->about);
        $about = SettingHelper::getSetting("about");
        Alert::toast('privacy policy updated successfully', 'info');
        return view('admin.about.index')->with('about', $request->about);
    }


    public function edit($id)
    {
        /*
       if(!$check){
           return view('components.error')->with('error', "you dont have permission to do this action");
       }
       */
        $setting = Setting::find($id);
        return view('admin.settings.edit')->with('setting', $setting);

    }


    public function update(Request $request, Setting $setting)
    {
        Log::info("dfsdfsdfsdfsdfsdfs");

        // abort_if(!auth()->user()->hasPermission('update setting'),403,"you dont have permission to access this page");


        $request->validate(['value' => 'required']);
        // $setting->key = $request->key;
        $setting->value = $request->value;

        $setting->type = $request->type;
        $setting->description = $request->description;

        $setting->save();
        Alert::toast('new setting updated successfully', 'success');
        return redirect()->route('admin.settings.index');

    }

    public function destroy($id)
    {

    }
}
