<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\QuizQuestion;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class QuizQuestionController extends Controller
{

    public function index()
    {

    }


    public function create()
    {

    }


    public function store(Request $request)
    {




        $validator = validator()->make($request->all(), [
            'course_test_id'=>'required|integer',
            'question'=>'required|string',
            'answer_a'=>'required|string',
            'answer_b'=>'required|string',
            'answer_c'=>'required|string',
            'answer_d'=>'required|string',
            'correct_answer'=>'required|string',
        ]);
        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $exam = new QuizQuestion();
        $exam->user_id = auth()->id();
        $exam->course_test_id = $request->course_test_id;
        $exam->question = $request->question;
        $exam->answer_a = $request->answer_a;
        $exam->answer_b = $request->answer_b;
        $exam->answer_c = $request->answer_c;
        $exam->answer_d = $request->answer_d;
        $exam->correct_answer = $request->correct_answer;
        $exam->save();

        Alert::toast('new question was created', 'success');
        return redirect()->back();


    }


    public function show(QuizQuestion $quizQuestion)
    {

    }


    public function edit(QuizQuestion $quizQuestion)
    {

        return view('admin.courses.quiz.edit')->with('question',$quizQuestion);

    }


    public function update(Request $request,QuizQuestion $quizQuestion)
    {
        $validator = validator()->make($request->all(), [
            'question'=>'required|string',
            'answer_a'=>'required|string',
            'answer_b'=>'required|string',
            'answer_c'=>'required|string',
            'answer_d'=>'required|string',
            'correct_answer'=>'required|string',
        ]);
        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $quizQuestion->question = $request->question;


        $quizQuestion->answer_a = $request->answer_a;
        $quizQuestion->answer_b = $request->answer_b;
        $quizQuestion->answer_c = $request->answer_c;
        $quizQuestion->answer_d = $request->answer_d;
        $quizQuestion->correct_answer = $request->correct_answer;
        $quizQuestion->save();

        Alert::toast('question was updated successfully', 'success');
        return redirect()->back();

    }

    public function destroy(QuizQuestion $quizQuestion)
    {

        $quizQuestion->delete();
        Alert::toast('question was removed successfully', 'info');
        return redirect()->back();
    }
}
