<?php

namespace App\Http\Controllers\Admin;

use App\Models\Notification;
use App\Models\User;
use App\Services\FCMService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;

class NotificationController extends Controller
{

    public function index()
    {

        $notifications = Notification::orderByDesc('id')->paginate(14);
        return view('admin.notifications.index')->with('notifications',$notifications);

    }

    public function toUser($user_id)
    {

        $notifications = Notification::orderByDesc('id')->paginate(14);
        return view('admin.notifications.index')->with('notifications',$notifications)->with('user_id',$user_id);

    }


    public function create()
    {

    }


    public function store(Request $request)
    {

        if($request->type == "public"){
           return  $this->storeToAll($request);
        }else{
            return  $this->storeToUser($request);
        }

    }

    public function storeToUser(Request $request){

        $user = User::findOrFail($request->user_id);
        $notification = Notification::create([
            'type' => 'personal',
            'title' => 'This is a personal notification.',
            'description' => 'This is a personal notification.',
            'user_id' => $user->id,
        ]);
        $user->notifications()->attach($notification->id);

        FCMService::sendNotification('personal',$request->title, $request->description);
        Alert::toast('notification sent successfully','success');
        return redirect()->route('admin.notifications.index');
    }
    public function storeToAll(Request $request){
        $notification = Notification::create([
            'type' => 'public',
            'title' =>  $request->title,
            'description' => $request->description,
        ]);
        $users = User::all();
        foreach ($users as $user) {
            $user->notifications()->attach($notification->id);
        }

         FCMService::sendNotification('public',$request->title, $request->description);
       // dd($a);
        Alert::toast('notification sent successfully','success');
        return redirect()->route('admin.notifications.index');
    }




    public function show(Notification $notification)
    {

    }


    public function edit(Notification $notification)
    {

    }


    public function update(Request $request, Notification $notification)
    {

    }


    public function destroy(Notification $notification)
    {
        $notification->delete();
        Alert::toast('notification was removed successfully','success');
        return redirect()->route('admin.notifications.index');
    }
}
