<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CourseContent;
use App\Models\CourseTest;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class CourseTestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CourseTest  $courseTest
     * @return \Illuminate\Http\Response
     */
    public function show(CourseTest $courseTest)
    {
        //
    }


    public function edit(CourseTest $courseTest)
    {
     return view('admin.courses.content.edit_quiz')->with('courseTest',$courseTest);
    }


    public function update(Request $request, CourseTest $courseTest)
    {
        $validator = validator()->make($request->all(), [
            'title' => 'required|string',
            'active' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

 
        $courseTest->title = $request->title;
        $courseTest->active = $request->active;
        $courseTest->save();


        Alert::toast('Quiz Updated','success');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CourseTest  $courseTest
     * @return \Illuminate\Http\Response
     */
    public function destroy(CourseTest $courseTest)
    {
        //
    }
}
