<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use App\Models\Category;
use App\Models\CouponCode;
use App\Models\Course;
use App\Models\CourseContent;
use App\Models\CourseTest;
use App\Models\Student;
use App\Models\QuizQuestion;
use App\Models\TextQuestion;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;
use App\Services\FCMService;
use App\Models\User;
use App\Models\Notification;
use App\Models\JoinReq;
use Illuminate\Support\Facades\Storage;

class CourseController extends Controller
{

    public function joinReqs($id){

        $joinreqs = JoinReq::where('course_id',$id)->with(['user:id,name,image'])->orderBy('id','DESC')->paginate(15);
        $course = Course::findOrFail($id);

        return view('admin.courses.joinreqs.index')->with('course',$course)->with('joinreqs',$joinreqs);

    }

     public function toggleCourse($id,$state){


        $workshop = Course::findOrFail($id);
        $workshop->is_active = $state;
        $workshop->save();

        if($state == '0'){

             Alert::toast('Course was hidden successfully', 'success');
        }else{
             $notification = Notification::create([
                'type' => 'public',
                'title' =>  "المحكمة الافتراضية",
                'description' => "تم نشر كورس جديد",
            ]);
            $users = User::all();
            foreach ($users as $user) {
                $user->notifications()->attach($notification->id);
            }
           FCMService::sendNotification('public',"المحكمة الافتراضية", "تم نشر كورس جديد");
           Alert::toast('Course actived successfully', 'success');

        }

        return redirect()->route('admin.courses.index');

    }


    public function index()
    {

        $courses = Course::orderBy('id','desc')->with('category')->paginate(12);
        $categories = Category::select('id', 'name', 'cat_type', 'father_category_id')
        ->where('father_category_id', '!=', '0')
        ->where('cat_type', '0')
        ->get();
        return view('admin.courses.index')->with(['courses' => $courses, 'categories' => $categories]);

    }

    public function students($course_id)
    {


         $students = Student::where('course_id',$course_id)->with(['user:id,name,image'])->paginate(15);

        return view('admin.courses.students.index')->with('students',$students);

    }

    public function exam($course_id) {
        $course = Course::findOrFail($course_id);
        $questions = TextQuestion::where('course_id',$course_id)->orderBy('id','ASC')->get();
        return view('admin.courses.exam.index')->with('questions',$questions)->with('course',$course);
    }


    public function create()
    {

    }


    public function store(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',

            'hours' => 'nullable|numeric',
            'category_id' => 'nullable|numeric',
            'author_id' => 'required|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'is_free' => 'required|boolean',
        ]);


        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $course = new Course();
        $course->user_id = auth()->id();
        $course->category_id = $request->category_id;
        $course->author_id = $request->author_id;
        $course->name = $request->name;
        $course->description = $request->description;
        $course->price = $request->price;

        $course->hours = $request->hours;

        $course->is_free = $request->is_free;






        if ($request->hasFile('image')) {
            $course->image =  ImageHelper::storeImage('courses/',$request->image);
        }

        if ($request->hasFile('pdf')) {
            $course->pdf =  ImageHelper::storeImage('files/',$request->pdf);
        }

        // حفظ بيانات الدورة
        $course->save();



        $dir = $request->dir;
        $path ='Virtual Court/courses/c_'.$course->id;

        // Check if the folder already exists
        if (!Storage::disk('s3')->exists($path)) {
            Storage::disk('s3')->makeDirectory($path);
        }





        // إظهار رسالة نجاح
        Alert::toast('Course created successfully', 'success');
        return redirect()->route('admin.courses.index');
    }


    public function content( $courseId){
        $course = Course::findOrFail($courseId);



        // Load the course content (lessons and tests)
        $courseContents = CourseContent::where('course_id', $courseId)->get();

        return view('admin.courses.content.index')->with('course',$course)->with('courseContents',$courseContents);
    }


    public function show(Course $course)
    {
        $couponCodes = CouponCode::where('course_id',$course->id)->orderBy('id','desc')->get();
        return view('admin.coupons.index', compact('couponCodes','course'));
    }


    public function showQuiz($quizId)
    {
        $test = CourseTest::findOrFail($quizId);
        $questions = QuizQuestion::where('course_test_id',$quizId)->orderBy('id','desc')->paginate(16);

        return view('admin.courses.quiz.index', compact('questions','test'));
    }


    public function edit(Course $course)
    {
        $categories = Category::select('id', 'name', 'cat_type', 'father_category_id')
        ->where('father_category_id', '!=', '0')
        ->where('cat_type', '0')
        ->get();
        return view('admin.courses.edit')->with(['course' => $course, 'categories' => $categories]);
    }


    public function update(Request $request, Course $course)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',

            'hours' => 'nullable|numeric',
            'category_id' => 'nullable|numeric',
            'author_id' => 'required|numeric',

            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'is_free' => 'required|boolean',
            'is_exam_active' => 'required|boolean',
        ]);


        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $course->category_id = $request->category_id;
        $course->name = $request->name;
        $course->description = $request->description;
        $course->price = $request->price;
        $course->author_id = $request->author_id;

        $course->is_exam_active = $request->is_exam_active;

        $course->hours = $request->hours;
        $course->promo_link = $request->promo_link;

        $course->is_free = $request->is_free;



        if ($request->hasFile('image')) {
            $course->image =  ImageHelper::storeImage('courses/',$request->image);
        }
        if ($request->hasFile('pdf')) {
            $course->pdf =  ImageHelper::storeImage('files/',$request->pdf);
        }

        $course->save();

        Alert::toast('Course updated successfully', 'success');
        return redirect()->route('admin.courses.index');
    }


    public function destroy(Course $course)
    {
        $course->delete();
        Alert::toast('Course deleted successfully', 'success');
        return redirect()->route('admin.courses.index');
    }
}
