<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use App\Models\Category;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class CategoryController extends Controller
{

    public function index(Request $request)
    {
        $cat_type = $request->cat_type;
        $categories = Category::query();

        if (!is_null($cat_type)) {
            $categories->where('cat_type', $cat_type);
        }
        $categories = $categories->get();

        return view('admin.category.index')->with('categories', $categories);
    }

    public function create()
    {

    }


    public function store(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string',
            'image' => 'required|image|mimes:png,jpg,jpeg'
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $category = new Category();
        $category->name = $request->name;
        $category->cat_type = $request->cat_type;
        $category->image = ImageHelper::storeImage('cats/', $request->image);

        $category->father_category_id = $request->father_category_id;

        $category->save();

        Alert::toast('category created', 'success');
        return redirect()->route('admin.categories.index');

    }


    public function show(Category $category)
    {

    }


    public function edit(Category $category)
    {
        $categories = Category::all();
        return view('admin.category.edit')->with(['category' => $category, 'categories' => $categories]);

    }


    public function update(Request $request, Category $category)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string'
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $category->name = $request->name;
        $category->cat_type = $request->cat_type;
        if ($request->hasFile('image')) {
            $category->image = ImageHelper::storeImage('cats/', $request->image);
        }

        $category->father_category_id = $request->father_category_id;

        $category->save();

        Alert::toast('category updated', 'success');
        return redirect()->route('admin.categories.index');

    }


    public function destroy(Category $category)
    {
        $category->delete();
        Alert::toast('category removed', 'success');
        return redirect()->route('admin.categories.index');
    }
}
