<?php

namespace App\Http\Controllers\Admin;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\ValidationException;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;

class AuthController extends Controller
{
    public function index(){
        if(Auth::check()){
            return redirect()->route('admin.home');
        }
        return view('auth.login');
    }

    public function login(Request $request){
        $request->validate([
            'email'    => 'required|email',
            'password' => 'required',
        ]);

        $usr = User::where('email',$request->email)->count();

        if($usr>0){
            $usr = User::where('email',$request->email)->where('role_id','=','1')->count();
            if($usr>0){
                Alert::error('you dont have permission to login ', 'error');
                return redirect(route('admin.login'));
            }




        }else{
            Alert::error('invalid email address ', 'error');
            return redirect(route('admin.login'));
        }


        $credential=['email'=>$request->email,'password'=>$request->password];

        if(Auth::attempt($credential)){
            Alert::toast('welcome '.auth()->user()->name, 'success');
            return redirect(route('admin.statistics'));
        }else{
            Alert::error('Login Error', 'invalid email or password');
            return redirect()->route('admin.login');
        }
    }

    public function logout(){


        Auth::logout();

        return redirect()->route('admin.login');
    }
}
